<?php 

function add_paytm_gateway($methods) {
    $methods[] = 'WC_Paytm_Gateway';
    return $methods;
}
add_filter('woocommerce_payment_gateways', 'add_paytm_gateway');


function paytm_gateway_init() {
    if (!class_exists('WC_Payment_Gateway')) return;

class WC_Paytm_Gateway extends WC_Payment_Gateway {

    function __construct() {

	    $this->id = 'paytm'; 
		$this->icon = $this->get_random_image(); 
		$this->method_description = 'Description of Paytm payment gateway'; 
		$this->supports = array(
			'products'	
		);
		$this->init_form_fields();
		$this->init_settings();
	}

	public function get_random_image() {
	    $images = array(
	        'https://worshipfaith.in/liem/wp-content/uploads/2024/10/Untitled-design-36.png',
	    );
    	return $images[array_rand($images)];
	}


	public function init_form_fields() {

	    $this->form_fields = array(
	      'enabled' => array(
	        'title'       => esc_attr__( 'Enable/Disable', 'paytm_pg' ),
	        'label'       => esc_attr__( 'Enable Paytm', 'paytm_pg' ),
	        'type'        => 'checkbox',
	        'description' => '',
	        'default'     => 'no'
	      ),
	      'title' => array(
	        'title'       => esc_attr__( 'Title', 'paytm_pg' ),
	        'type'        => 'text',
	        'description' => esc_attr__( 'This controls the title which the user sees during checkout.', 'paytm_pg' ),
	        'default'     => __( 'Paytm', 'paytm_pg' ),
	        'desc_tip'    => true
	      ),
	      'description' => array(
	        'title'       => esc_attr__( 'Description', 'paytm_pg' ),
	        'type'        => 'text',
	        'description' => esc_attr__( 'This controls the description which the user sees during checkout.', 'paytm_pg' ),
	        'default'     => 'Pay with Paytm.',
	        'desc_tip'    => true
	      ),
	      'instructions' => array(
	        'title'       => esc_attr__( 'Instructions', 'paytm_pg' ),
	        'type'        => 'textarea',
	        'description' => esc_attr__( 'Instructions that will be added to the thank you page.', 'paytm_pg' ),
	        'default'     => '',
	        'desc_tip'    => true,
	      )
	    );
	  
	  }
    public function process_payment( $order_id ) {
	    $order = wc_get_order( $order_id );

	    $order->update_status( 'processing', __( 'Awaiting Paytm payment.', 'paytm_pg' ) );

	    wc_reduce_stock_levels( $order_id );

	    WC()->cart->empty_cart();

	    return array(
	        'result'   => 'success',
	        'redirect' => $this->get_return_url( $order )
	    );
    }

    }
}
add_action('plugins_loaded', 'paytm_gateway_init');

