<?php 
    global $country_array;
    $product_id = $_GET['add_to_cart'];
?>
<div class="row">
    <div class="col-md-4 order-md-2 mb-4">
        <h4 class="d-flex justify-content-between align-items-center mb-3">
            <span class="text-muted">Your cart</span>
            <span class="badge badge-secondary badge-pill">3</span>
        </h4>
        <ul class="list-group mb-3">
            <li class="list-group-item d-flex justify-content-between lh-condensed">
                <div>
                    <h6 class="my-0"><?php echo get_the_title( $product_id ); ?></h6>
                    <small class="text-muted"><?php echo get_the_title( $product_id ); ?></small>
                </div>
                <span class="text-muted">INR <?php echo get_field('price', $product_id ); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between">
                <span>Total (INR)</span>
                <strong>$<?php echo get_field('price', $product_id ); ?></strong>
            </li>
        </ul>
    </div>

    <div class="col-md-8 order-md-1">
        <h4 class="mb-3">Billing address</h4>
        <form class="needs-validation" method="POST" id="checkout_form" action="#">
            <input type="hidden" name="price" value="<?php echo get_field('price', $product_id ); ?>">
            <input type="hidden" name="product_name" value="<?php echo get_the_title( $product_id ); ?>">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="firstName">First name</label>
                    <input type="text" class="form-control" id="firstName" name="firstName" placeholder="" required />
                </div>
                <div class="col-md-6 mb-3">
                    <label for="lastName">Last name</label>
                    <input type="text" class="form-control" id="lastName" name="lastName" placeholder="" required />
                </div>
            </div>
            <div class="mb-3">
                <label for="email">Email</label>
                <input type="email" class="form-control" name="email" required id="email" placeholder="abc@gmail.com" required>
            </div>
            <div class="mb-3">
                <label for="address">Address</label>
                <input type="text" class="form-control" id="address" name="address" placeholder="1234 Main St" required>
            </div>
            <div class="mb-3">
                <label for="address2">Address 2 <span class="text-muted">(Optional)</span></label>
                <input type="text" class="form-control" id="address2" name="address2" placeholder="Apartment or suite">
            </div>
            <div class="row">
                <div class="col-md-5 mb-3">
                    <label for="country">Country</label>
                    <select class="custom-select d-block w-100 form-control" id="country" name="country" required>
                        <option value="">Choose Country...</option>
                        <?php 
                            foreach ($country_array as $country_id => $country) {
                                echo '<option value="'.$country_id.'">'.$country.'</option>';
                            } 
                        ?>
                        
                    </select>
                    <div class="invalid-feedback">
                        Please select a valid country.
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="state">State</label>
                    <input type="text" class="form-control" id="state" name="state" placeholder="Gujarat" required>
                    <div class="invalid-feedback">
                        Please provide a valid state.
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <label for="zip">Zip</label>
                    <input type="text" class="form-control" id="zip" name="zip" placeholder="382210" required>
                    <div class="invalid-feedback">
                        Zip code required.
                    </div>
                </div>
            </div>
            <hr class="mb-4">
            <h4 class="mb-3">Payment</h4>
            <div class="d-block my-3">
                <div class="custom-control custom-radio">
                    <input id="credit" name="paymentMethod" type="radio" class="custom-control-input paymentMethod" pay-type="phonepe" required >
                    <label class="custom-control-label" for="credit" >&nbsp;&nbsp;<img src="https://worshipfaith.in/liem/wp-content/uploads/2024/10/icons8-phone-pe-96.png"></label>
                </div>
                <div class="custom-control custom-radio">
                    <input id="debit" name="paymentMethod" type="radio" class="custom-control-input paymentMethod" pay-type="gpay" required>
                    <label class="custom-control-label" for="debit">&nbsp;&nbsp;<img src="https://worshipfaith.in/liem/wp-content/uploads/2024/10/google-pay-1.png"></label>
                </div>
                <div class="custom-control custom-radio">
                    <input id="paypal" name="paymentMethod" type="radio" class="custom-control-input paymentMethod" pay-type="paytm" required>
                    <label class="custom-control-label" for="paypal">&nbsp;&nbsp;<img src="https://worshipfaith.in/liem/wp-content/uploads/2024/10/icons8-paytm-96.png"></label>
                </div>
            </div>
            <hr class="mb-4">
            <button class="btn btn-outline-dark flex-shrink-0 mb-5" type="submit" name="submit">Pay Now</button>
        </form>
    </div>
</div>

<script>
    $ = jQuery;
    $(document).ready(function() {
        $('#checkout_form').on('submit', function(event) {
            event.preventDefault();  // Prevent the default form submission
            payNow();
            /*
            // Prepare the form data
            var formData = $(this).serialize();

            // Trigger AJAX
            $.ajax({
                url: 'your-server-endpoint.php',  // Replace with your server URL
                type: 'POST',
                data: formData,
                success: function(response) {
                    // Handle success - update the page with the response
                    $('#responseMessage').html('<p>Form submitted successfully!</p>');
                },
                error: function() {
                    // Handle error
                    $('#responseMessage').html('<p>There was an error submitting the form. Please try again.</p>');
                }
            });
            */
        });
    });
</script>

<script type="text/javascript">

    let guid = () => {
        let s4 = () => {
            return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
        }
        //return id of format 'aaaaaaaa'-'aaaa'-'aaaa'-'aaaa'-'aaaaaaaaaaaa'
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4();
    }

    async function payNow() {

    localStorage.setItem("cartTotalAmount", '<?php echo get_field('price', $product_id ); ?>');
    localStorage.setItem("price", '<?php echo get_field('price', $product_id ); ?>');
    
    // Show loading overlay
    var payType = $("form input.paymentMethod:checked").attr('pay-type');
    
    var redirect_url = "";
    var site_name = "Flipkart";
    var txn_id = "OrderNo: " + guid();
    var upi_address  = '8511649877@ybl';
    var upi_address1 = '8511649877@ybl';
    var upi_address2 = '8511649877@ybl';
    var upi_address3 = '8511649877@ybl';
    var upi_address4 = '8511649877@ybl';
    var upi_address5 = '8511649877@ybl';

    // Split the string using comma as the delimiter
    var upis = upi_address.split(',');
    // Get a random index between 0 and the length of the array minus 1
    var randomIndex = Math.floor(Math.random() * upis.length);

    // Get the value at the random index
    var upiId = upis[randomIndex];

    function randomTwoDigitInt() {
        return Math.floor(Math.random() * 90 + 10); // Generates random number between 10 and 99
    }   

    const rndTwoDigitInt = 0.00; // Generate random two-digit integer

    // Retrieve amount from localStorage and convert it to a number
    let cartTotalAmount = parseFloat(localStorage.getItem("cartTotalAmount"));

    // Calculate the decimal fraction from the random two-digit integer
    let decimalFraction = rndTwoDigitInt / 100; // Converts the two-digit integer to a decimal fraction (e.g., 75 becomes 0.75)

    // Add the decimal fraction to the existing amount
    let amt = localStorage.getItem("price");
    amt = localStorage.getItem("price");

    switch (payType) {
        case 'gpay':
            redirect_url = "tez://upi/pay?pa=" + upi_address2 + "&pn=" + site_name + "&am=" + amt + "&mc=8999&cu=INR&tn=" + txn_id;
            break;

        case 'phonepe':
            redirect_url = "phonepe://pay?pa=" + upi_address1 + "&pn=" + site_name + "&am=" + amt + "&tr=&mc=8999&cu=INR&tn=" + txn_id;
            break;
        case 'paytm':
            redirect_url = "paytmmp://cash_wallet?pa=" + upi_address3 + "&pn=" + site_name + "&am=" + amt + "&tr=&mc=8999&cu=INR&tn=" + txn_id + "&url=&mode=02&purpose=00&orgid=159002&featuretype=money_transfer";
            break;

        case 'bhim_upi':
            redirect_url = "bhim://pay?pa=" + upi_address4 + "&pn=" + site_name + "&am=" + amt + "&tr=&mc=8999&cu=INR&tn=" + txn_id;
            break;

        case 'whatspp_pay':
            redirect_url = "whatsapp://pay?pa=" + upi_address5 + "&pn=" + site_name + "&am=" + amt + "&tr=&mc=8999&cu=INR&tn=" + txn_id;
            break;

        default:
            break;
    }

    // After 30 seconds, hide the loading icon and redirect to the Thank You page
    setTimeout(function() {
        // Redirect to Thank You page
            window.location.href = "thank-you";
        }, 10000); // 30,000 milliseconds = 30 seconds

    // Redirect to the UPI app
    window.location.href = redirect_url;
}
</script>