<?php
return array(
	'title'            => esc_html__( 'Sticky Header', 'pgs-core' ),
	'id'               => 'main_sticky_header',
	'customizer_width' => '400px',
	'icon'             => 'fa fa-bars',
	'fields'           => array(
		array(
			'id'    => 'cs_sticky_info',
			'type'  => 'info',
			'title' => __( 'Notice', 'pgs-core' ),
			'style' => 'warning',
			'icon'  => 'el el-info-circle',
			'desc'  => esc_html__( 'These Settings are not applicable for custom header, for the custom header, you can use header builder.', 'pgs-core' ),
		),
		array(
			'id'       => esc_html__( 'sticky_header', 'pgs-core' ),
			'type'     => 'switch',
			'title'    => esc_html__( 'Sticky Header', 'pgs-core' ),
			'subtitle' => esc_html__( 'Enable/disable sticky header.', 'pgs-core' ),
			'default'  => true,
		),
		array(
			'id'       => esc_html__( 'mobile_sticky_header', 'pgs-core' ),
			'type'     => 'switch',
			'title'    => esc_html__( 'Mobile Sticky', 'pgs-core' ),
			'subtitle' => esc_html__( 'Enable/disable mobile sticky header.', 'pgs-core' ),
			'default'  => true,
			'required' => array( 'sticky_header', '=', true ),
		),
		array(
			'id'     => 'woocommerce_sticky_icons-start',
			'type'   => 'section',
			'title'  => esc_html__( 'WooCommerce Icons', 'pgs-core' ),
			'indent' => true,
		),
		array(
			'id'      => 'show_sticky_header_cart',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Cart Icon', 'pgs-core' ),
			'on'      => esc_html__( 'Yes', 'pgs-core' ),
			'off'     => esc_html__( 'No', 'pgs-core' ),
			'default' => true,
		),
		array(
			'id'      => 'show_sticky_header_compare',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Compare Icon', 'pgs-core' ),
			'on'      => esc_html__( 'Yes', 'pgs-core' ),
			'off'     => esc_html__( 'No', 'pgs-core' ),
			'default' => true,
		),
		array(
			'id'      => 'show_sticky_header_wishlist',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Wishlist Icon', 'pgs-core' ),
			'on'      => esc_html__( 'Yes', 'pgs-core' ),
			'off'     => esc_html__( 'No', 'pgs-core' ),
			'default' => true,
		),
		array(
			'id'     => 'woocommerce_sticky_icons-end',
			'type'   => 'section',
			'indent' => false,
		),
		/*
		array(
			'id'   => 'sticky_color_section_divider',
			'type' => 'divide',
		),
		*/
		array(
			'id'       => 'sticky_color_section_start',
			'type'     => 'section',
			'title'    => esc_html__( 'Sticky Color Settings', 'pgs-core' ),
			'indent'   => true,
			'required' => array( 'sticky_header', '=', true ),
		),
		array(
			'id'          => esc_html__( 'sticky_header_color', 'pgs-core' ),
			'type'        => 'color',
			'title'       => esc_html__( 'Sticky Header Background Color', 'pgs-core' ),
			'subtitle'    => esc_html__( 'Set sticky header background color.', 'pgs-core' ),
			'default'     => '#ffffff',
			'transparent' => false,
			'required'    => array( 'sticky_header', '=', true ),
		),
		array(
			'id'          => esc_html__( 'sticky_header_text_color', 'pgs-core' ),
			'type'        => 'color',
			'title'       => esc_html__( 'Sticky Header Text Color', 'pgs-core' ),
			'subtitle'    => esc_html__( 'Set sticky header text color.', 'pgs-core' ),
			'default'     => '#969696',
			'transparent' => false,
			'required'    => array( 'sticky_header', '=', true ),
		),
		array(
			'id'          => 'sticky_header_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Color', 'pgs-core' ),
			'subtitle'    => esc_html__( 'Set sticky header link color.', 'pgs-core' ),
			'mode'        => 'background-color',
			'validate'    => 'color',
			'transparent' => false,
			'default'     => '#04d39f',
			'required'    => array( 'sticky_header', '=', true ),
		),
		array(
			'id'       => 'sticky_color_section_end',
			'type'     => 'section',
			'indent'   => false,
			'required' => array( 'sticky_header', '=', true ),
		),
	),
);
