<?php
add_action( 'wp_ajax_mailchimp_singup', 'pgscore_mailchimp_signup_action' );
add_action( 'wp_ajax_nopriv_mailchimp_singup', 'pgscore_mailchimp_signup_action' );
function pgscore_mailchimp_signup_action() {
	$return         = new WP_Error( 'something_wrong', esc_html__( 'Something went wrong. Please try again later.', 'pgs-core' ) );
	$ciyashop_nonce = isset( $_POST['ajax_nonce'] ) ? sanitize_key( wp_unslash( $_POST['ajax_nonce'] ) ) : '';
	$api_key        = '';
	$list_id        = '';

	if ( ! wp_verify_nonce( $ciyashop_nonce, 'ciyashop_nonce' ) ) {
		$return = new WP_Error( 'bad_nonce', esc_html__( 'Unable to verify security nonce. Please try again later.', 'pgs-core' ) );
	} else {
		global $pgscore_globals;

		$theme_option = $GLOBALS[ $pgscore_globals['options_name'] ];

		// Configure API Key.
		if ( isset( $theme_option['mailchimp_api_key'] ) && ! empty( $theme_option['mailchimp_api_key'] ) ) {
			$api_key = esc_html( $theme_option['mailchimp_api_key'] );
		}

		// Override API Key from wp-config.php
		if ( defined( 'PGSCORE_MAILCHIMP_APIKEY' ) && ! empty( PGSCORE_MAILCHIMP_APIKEY ) ) {
			$api_key = PGSCORE_MAILCHIMP_APIKEY;
		}

		// Configure List ID.
		if ( isset( $theme_option['mailchimp_list_id'] ) && ! empty( $theme_option['mailchimp_list_id'] ) ) {
			$list_id = esc_html( $theme_option['mailchimp_list_id'] );
		}

		// Override API Key from wp-config.php
		if ( defined( 'PGSCORE_MAILCHIMP_LISTID' ) && ! empty( PGSCORE_MAILCHIMP_LISTID ) ) {
			$list_id = PGSCORE_MAILCHIMP_LISTID;
		}

		require_once trailingslashit( PGSCORE_PATH ) . 'includes/lib/mailchimp/class-pgs-mailchimp.php'; // mailchimp class library

		$email     = sanitize_email( $_REQUEST['newsletter_email'] );
		$mailchimp = new PGS_Mailchimp( $api_key, $list_id );
		$return    = $mailchimp->subscribe( $email );
	}

	if ( is_wp_error( $return ) ) {
		// var_dump( $return->get_error_code() );
		?>
		<p class="text-danger"><?php echo esc_html( $return->get_error_message() ); ?></p>
		<?php
	} else {
		?>
		<p class="text-success"><?php echo esc_html( $return ); ?></p>
		<?php
	}
	die();
}
