## Version 4.17.0 (July 25, 2024)
* Fixed: Fixed outdated WooCommerce templates.
* Updated: Updated bundled plugins.

## Version 4.16.0 (May 07, 2024)
* Added: Added feature to add/change elements in mobile sticky footer.
* Fixed: Fixed issue where Theme Options > Header > Site Header is not displaying after updating Redux Framework to v4.4.16.
* Fixed: Fixed typo.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.15.1 (March 05, 2024)
* Fixed: Fixed translation issue with "Category/Categories" word on the product detail page.
* Fixed: Fixed Elementor Products widget pagination conflict ajax product filter.
* Fixed: Fixed WooCommerce Cart/Checkout Block design issues.
* Fixed: Fixed Redux Option new dropdown design issue.
* Updated: Updated bundled core plugin.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.15.0 (November 18, 2023)
* Added: Added support to unselect the selected Size Guide in the product editor.
* Fixed: Fixed issue where Size Guide popup is showing product description when description is made with Elementor.
* Fixed: Fixed OnVeggy sample import not working in Elementor.
* Fixed: Fixed text overlap issue in product list on mobile view.
* Fixed: Fixed Elementor Pro Products widget display issue.
* Fixed: Fixed error on 404 page when "Page Content Type" field is set to "Page" in Theme Options > 404 Page setting.
* Fixed: Fixed issue where shortcode not working in the Header Builder > Text Block.
* Fixed: Fixed typo.
* Removed: Removed duplicate codes.
* Updated: Updated bundled core plugin.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes

## Version 4.14.0 (August 25, 2023)
* Added: Added new Product Page Style theme option "WooCommerce Default" to display the original WooCommerce Product Gallery so users can use third-party gallery plugins.
* Fixed: Fixed typo.
* Updated: Added deprecated notice for the Instagram WPBakery shortcode.
* Removed: Removed old Instagram widget as it is no longer compatible with the new Instagram API.
* Updated: Updated Font Awesome to v6.4.2.
* Updated: Added compatibility with Font Awesome v6.x in social profile icons.
* Updated: Updated icons in the Mega Menu Icon Selector to Font Awesome v6.4.2.
* Updated: Updated bundled core plugin.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.13.0 (August 08, 2023)
* Added: Added new theme options for modifying behavior after adding products to the wishlist and cart.
* Updated: Updated bundled core plugin.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.12.2 (July 18, 2023)
* Fixed: Fixed Place Order and Proceed to Checkout button issue on Mobile view.
* Fixed: Fixed outdated WooCommerce 7.9.0 templates.
* Fixed: Fixed double Ajax request when submitting newsletter form.
* Fixed: Fixed fatal error when YITH WooCommerce Brands Add-on is active and activating the PGS Core plugin.
* Fixed: Fixed newsletter shortcode not working.
* Updated: Updated bundled core plugin.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.12.1 (June 16, 2023)
* Updated: Updated bundled plugins.
* Updated: WooCommerce templates with the latest version.

## Version 4.12.0 (June 02, 2023)
* Added: Stock filter widget for the shop page.
* Fixed issue where enabling/disabling the off-canvas sidebar on mobile is not working
* Fixed: Issue where the "Display Breadcrumb on Mobile" Theme option is not working.
* Fixed: Date Picker field arrow text overlap CSS issue in shortcode.
* Fixed: Product categories not showing in Potenza listing and multi-listing product widget select option.
* Fixed: Product video field not working properly.
* Fixed: PHP 8.2 related issues.
* Updated: PHPCS issues, wrong escaping, and bugs related to spacing and code formatting.
* Updated: Updated language files.
* Updated: Add a new option to select individual products for listing in the product listing widget/shortcode.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.11.0 (April 06, 2023)
* Added: New WPBackery & elementor category 'Grocery'
* Fixed: Variation issue when variation count is more than than variation threshold on quick view pop-up.
* Fixed: The mobile menu does not show up when the sticky menu is enabled.
* Fixed: Fatal error when newsletter set for coming soon option theme option.
* Fixed: WooCoommerce notice when maintenance mode is on.
* Fixed: various PHP notices and warnings.
* Fixed: Fixed deprecated functions.
* Added: New hover styles "Grocery 1" and "Grocery 2"
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.10.3 (February 23, 2023)
* Added: Added Home Slider sample data for Elementor.
* Fixed: Fixed issue with Helloween demo import.
* Fixed: Fixed outdated WooCommerce templates.
* Fixed: Fixed variation change issue when variations are more than variation threshold.
* Fixed: Fixed fatal error on shop page due to shop filter widget.
* Fixed: Fixed PHP 8.x compatibility notices.
* Fixed: Fixed fatal error when theme is not active but PGS Core plugin is active.
* Fixed: Fixed fatal error when cart is not found.
* Fixed: Fixed filter hook not working properly.
* Fixed: Fixed various PHP notices and warnings.
* Fixed: Fixed typo.
* Fixed: Minor fix in 360 view for autoplay.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.10.2 (January 17, 2023)
* Added: Product image zoom Enable/Disable theme option for product detail page.
* Fixed: Deprecated function issue with new version of elementor plugin.
* Fixed: Fixed sticky header alignment issue on the Mac browsers.
* Fixed: Sticky header height issue in some specific conditions
* Updated: Minor code/formatting improvements and fixes.
* Updated: Updated bundled plugins.
* Updated: Updated language files.

## Version 4.10.1 (November 03, 2022)
* Fixed: Fixed outdated WooCommerce templates and added backward compatibility.
* Fixed: Fixed fatal error when static-block added in WooCommerce product.
* Updated: Updated bundled plugins.
* Updated: Updated language files.

## Version 4.10.0 (October 28, 2022)
* Added: Added PHP 8.1 compatibility.
* Fixed: Fixed fatal error when WooCommerce is not active.
* Fixed: Fixed fatal error for missing class.
* Fixed: Fixed various PHP warnings, notices & deprecated notices.
* Fixed: Fixed "Add to Cart" button alignment in Related Products on Product page in mobile view.
* Fixed: Fixed unit price structure on the Wishlist page in mobile view when the product price is empty.
* Fixed: Fixed minor Add to Cart button formatting when price is blank.
* Fixed: Fixed login-form and language-switcher alignment issue on the login page.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.9.1 (September 28, 2022)
* Added: Added title element selection option in the Recent Post Elementor widget and WPbakery shortcode.
* Fixed: Fixed PHP notice.
* Fixed: Fixed deprecated functions.
* Fixed: Fixed text domain.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.9.0 (August 15, 2022)
* New: Added CiyaShop Studio for Elementor.
* Fixed: Fixed PHP notice.
* Fixed: Fixed Elementor deprecated notice.
* Fixed: Fixed typo.
* Fixed: Fixed text domain.
* Fixed: Fixed translation issue in the category list on the FAQ page.
* Fixed: Fixed color customizer CSS is not working correctly when SSL is enabled.
* Fixed: Fixed infinite scroll not working when filter applied.
* Fixed: Fixed cross-sells heading not displaying.
* Fixed: Fixed Elementor deprecated notice.
* Fixed: Fixed breadcrumb menu color issue when menu type is set to Side Menu in the header builder.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.8.4 (May 30, 2022)
* Fixed: Warning in the WooCommerce Shop category slider.
* Updated: Updated language files.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.8.3 (March 24, 2022)
* Fixed: Elementor deprecated functions/methods notices.
* Fixed: Clear filter button not working properly when ajax filter enabled on shop page.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.8.2 (January 28, 2022)
* Updated: WooCommerce templates with the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.8.1 (January 11, 2022)
* Fixed: Theme Option broken design in Latest 'Redux Framework' plugin.
* Fixed: In the footer builder editor field is not working properly.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.8.0 (October 18, 2021)
* Fixed: Ajax add to cart not working when ajax disabled for archive page in WooCommerce settings.
* Fixed: Blog page masonry layout issue.
* Fixed: Fixed font-awesome conflict with Elementor.
* Fixed: Filter not working properly when user set the shop page as front page.
* Fixed: Number of Item option in Product Listing widget/shortcode not working properly when some products are out of stock.
* Fixed: Duplicate H1 on the home page when custom header is set in header setting.
* Removed: Removed select2 from variation dropdown on the product detail page.
* Updated: Changed H1 to DIV on site-title/logo.
* Updated: Updated language files.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.7.2 (July 29, 2021)
* Fixed: Color scheme options not working in customizer.
* Fixed: Broken design in theme options for the latest version of the Redux plugin.
* Fixed: Widgets design issue fix.
* Fixed: Datepicker field not working for WpBakry page builder shortcode fields.
* Fixed: Theme Option not working with the new version of the redux plugin.
* Modified: Add option for two columns in a mobile device for product-related widget/shortcodes.
* Modified: Add a new theme option field ( Products Columns On Mobile - portrait ) to display two columns in mobile view for the product listing page.
* Updated: Minor code/formatting improvements and fixes.
* Updated: Bundled plugins updated to the latest version.

## Version 4.7.1.1 (June 03, 2021)
* Fixed: Console errors when sticky product title disabled or header builder used.

## Version 4.7.1 (June 02, 2021)
* Fixed: Console error when product attribute selected.
* Fixed: Search dropdown color issue fix.
* Fixed: Sticky Js library conflict with 'Elementor Pro' plugin.
* Updated: Partial support for the 'Elementor Pro' plugin.
* Updated: Cart Page design update in mobile view.
* Updated: Set 'Place Order' button sticky on the checkout page.
* Updated: Set 'Checkout Button' sticky on the cart page.

## Version 4.7.0 (May 24, 2021)
* Fixed: Newsletter widget/shortcode design Issue Fix.
* Added: New elementor category 'Coffee' and home page for 'Additional pages importer.'
* Added: New elementor category 'Antique' and home page for 'Additional pages importer.'
* Added: New elementor category 'Kitchen' and home page for 'Additional pages importer.'
* Added: New elementor category 'Suit' and home page for 'Additional pages importer.'
* Added: New elementor category 'Digital' and home page for 'Additional pages importer.'
* Added: New elementor category 'Fashion Classic' and home page for 'Additional pages importer.'
* Added: New home page 'Home 2' for 'Additional pages importer.'
* Added: New home page 'Home Mega' for 'Additional pages importer.'
* Added: New home page 'Home 4' for 'Additional pages importer.'
* Added: New home page 'Home 5' for 'Additional pages importer.'
* Added: New home page 'Home 6' for 'Additional pages importer.'
* Added: New home page 'Home 7' for 'Additional pages importer.'
* Updated: Added the hierarchical structure for category dropdown in search shortcode and widget.
* Updated: Bundled plugins updated to the latest version.

## Version 4.6.0 (May 17, 2021)
* Fixed: Multiple H1 tag issues on the blog page.
* Fixed: WooCommerce notice placed in the wrong position.
* Added: New elementor category 'Goggles' and home page for 'Additional pages importer.'
* Added: New elementor category 'Shisha' and home page for 'Additional pages importer.'
* Added: New elementor category 'Perfume' and home page for 'Additional pages importer.'
* Added: New elementor category 'Plumbing' and home page for 'Additional pages importer.'
* Added: New elementor category 'Ayurveda' and home page for 'Additional pages importer.'
* Added: New elementor category 'Weapon' and home page for 'Additional pages importer.'
* Added: New elementor category 'Fishing' and home page for 'Additional pages importer.'
* Added: New elementor category 'Ceramic' and home page for 'Additional pages importer.'
* Added: New elementor category 'Music Store' and home page for 'Additional pages importer.'
* Added: New elementor category 'Books' and home page for 'Additional pages importer.'
* Updated: Minor code/formatting improvements and fixes.

## Version 4.5.0 (May 07, 2021)
* Fixed: "Newsletter" widget Button Height Issue Fix.
* Fixed: "Static block" not working properly in megamenu.
* Added: New elementor category 'Garden' and home page for 'Additional pages importer.'
* Added: New elementor category 'Nails' and home page for 'Additional pages importer.'
* Added: New elementor category 'Toolkito' and home page for 'Additional pages importer.'
* Added: New elementor category 'Chocolate' and home page for 'Additional pages importer.'
* Added: New elementor category 'Gym' and home page for 'Additional pages importer.'
* Added: New elementor category 'Kids' and home page for 'Additional pages importer.'
* Added: New elementor category 'Denim' and home page for 'Additional pages importer.'
* Added: New elementor category 'Watch' and home page for 'Additional pages importer.'
* Added: New elementor category 'Organic Store' and home page for 'Additional pages importer.'
* Added: New elementor category 'Art Gallery' and home page for 'Additional pages importer.'
* Updated: Minor code/formatting improvements and fixes.

## Version 4.4.0 (April 27, 2021)
* Added: New elementor category 'Flower' and home page for 'Additional pages importer.'
* Added: New elementor category 'Leather' and home page for 'Additional pages importer.'
* Added: New elementor category 'Bakery' and home page for 'Additional pages importer.'
* Added: New elementor category 'Wedding' and home page for 'Additional pages importer.'
* Added: New elementor category 'Gift' and home page for 'Additional pages importer.'
* Added: New elementor category 'Mega Store' and home page for 'Additional pages importer.'
* Added: New elementor category 'Cake' and home page for 'Additional pages importer.'
* Added: New elementor category 'Wine' and home page for 'Additional pages importer.'
* Added: New elementor category 'Cigar' and home page for 'Additional pages importer.'
* Added: New elementor category 'Cleaning' and home page for 'Additional pages importer.'
* Added: New elementor category 'Auto Parts' and home page for 'Additional pages importer.'
* Added: New elementor category 'Fashion Modern' and home page for 'Additional pages importer.'
* Added: New elementor category 'Game' and home page for 'Additional pages importer.'
* Added: New elementor category 'Furniture' and home page for 'Additional pages importer.'
* Added: New elementor category 'Electronics' and home page for 'Additional pages importer.'
* Added: New elementor category 'Halloween' and home page for 'Additional pages importer.'
* Added: New elementor category 'Shoes' and home page for 'Additional pages importer.'
* Added: New elementor category 'Handmade' and home page for 'Additional pages importer.'
* Added: New elementor category 'Sport' and home page for 'Additional pages importer.'
* Added: New elementor category 'Landing Shoes' and home page for 'Additional pages importer.'
* Added: Add new option "Product Image Zoom magnify" in ( CiyaShop Theme Options > WooCommerce > Single Product ).
* Fixed: "Infobox" shortcode/widget Step Position Design Issue.
* Fixed: "Kitebox" shortcode/widget button Hover Issue.
* Fixed: "Image Bottom" Product Hover Style QTY Issue Fix in Dark Version.
* Fixed: Variable not selected when attribute passed directly on URL for swatches.
* Fixed: "Image Left" Product Hover Style "Read More" Button Issue.
* Fixed: "Newsletter" shortcode/widget Style 3 design Issue.
* Fixed: PHP 8 Deprecated notice.
* Fixed: Console error while uploading the images for a product in the smart product view section.
* Fixed: Image height issue for meta box image field.
* Updated: Out of stock will not visible in autocomplete if the 'Hide out of stock items from the catalog' option is enabled.
* Updated: Add new option to set the categories in default order for "Product Category Items" shortcode.
* Updated: Enable the mega menu option for the "Vertical Menu" shortcode/widget.
* Updated: Add new options for the side menu in "Header Builder" for the mobile menu element.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.3.0 (April 17, 2021)
* Added: New elementor category 'Headphones' and home page for 'Additional pages importer.'
* Added: New elementor category 'Military' and home page for 'Additional pages importer.'
* Added: New elementor category 'Tea Store' and home page for 'Additional pages importer.'
* Added: New elementor category 'Comic Bookshop' and home page for 'Additional pages importer.'
* Added: New elementor category 'Medicart' and home page for 'Additional pages importer.'
* Added: New elementor category 'Boots Fashion' and home page for 'Additional pages importer.'
* Added: New elementor category 'Ceramica' and home page for 'Additional pages importer.'
* Added: New elementor category 'Marijuana' and home page for 'Additional pages importer.'
* Added: New elementor category 'Stationery' and home page for 'Additional pages importer.'
* Added: New elementor category 'Bow Hunting' and home page for 'Additional pages importer.'
* Fixed: Team shortcode 'Style 2' design issue.
* Fixed: Newsletter shortcode validation error text alignment issue.
* Fixed: Theme dark design issue.
* Fixed: Mobile Menu alignment issue in responsive view.
* Fixed: Theme plugin section not accessible after all plugin activated.
* Fixed: Payment Method input field design issue on 'My Account Page' for 'WooCommerce Stripe Gateway' plugin.
* Updated: WooCommerce templates with the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.2.0 (April 09, 2021)
* Added: New elementor category 'Petstore' and home page for 'Additional pages importer.'
* Added: New elementor category 'Bicycle' and home page for 'Additional pages importer.'
* Added: New elementor category 'Bag' and home page for 'Additional pages importer.'
* Added: New elementor category 'Medical' and home page for 'Additional pages importer.'
* Added: New elementor category 'Spa' and home page for 'Additional pages importer.'
* Added: New elementor category 'Lingerie' and home page for 'Additional pages importer.'
* Added: New elementor category 'Fashion Vintage' and home page for 'Additional pages importer.'
* Added: New elementor category 'Spice Store' and home page for 'Additional pages importer.'
* Added: New elementor category 'Onveggie' and home page for 'Additional pages importer.'
* Added: New elementor category 'Jewellery' and home page for 'Additional pages importer.'
* Fixed: Promo PopUp Newsletter Design Issue Fix
* Fixed: Border issue in header builder.
* Fixed: Newsletter Style 3 Design Issue Fix.
* Fixed: Wrong active tab issue in mobile view for Sticky footer.
* Updated: Minor code/formatting improvements and fixes.

## Version 4.1.0 (April 01, 2021)
* Added: New elementor category 'Drone' and home page for 'Additional pages importer.'
* Added: New elementor category 'Vape Shop' and home page for 'Additional pages importer.'
* Added: New elementor category 'Beard Oil' and home page for 'Additional pages importer.'
* Added: New elementor category 'Olive Oil' and home page for 'Additional pages importer.'
* Added: New elementor category 'Car Parts' and home page for 'Additional pages importer.'
* Added: New elementor category 'Bear Shop' and home page for 'Additional pages importer.'
* Added: New elementor category 'Tools' and home page for 'Additional pages importer.'
* Added: New elementor category 'Ice Cream' and home page for 'Additional pages importer.'
* Added: New elementor category 'Water Shop' and home page for 'Additional pages importer.'
* Added: New elementor category 'Yoga Shop' and home page for 'Additional pages importer.'
* Added: New inner page 'About Us' page for 'Additional pages importer.'
* Added: New inner page 'About Us 2' page for 'Additional pages importer.'
* Added: New inner page 'Collection' page for 'Additional pages importer.'
* Added: New inner page 'Information' page for 'Additional pages importer.'
* Added: New inner page 'Contact Us' page for 'Additional pages importer.'
* Added: New inner page 'Contact Us 2' page for 'Additional pages importer.'
* Added: New inner page 'Term & Condition' page for 'Additional pages importer.'
* Added: New inner page 'Privacy Policy' page for 'Additional pages importer.'
* Added: New inner page 'Team Members' page for 'Additional pages importer.'
* Added: New inner page 'Typography' page for 'Additional pages importer.'
* Added: New inner page 'Payment Method' page for 'Additional pages importer.'
* Added: New inner page 'Shipping Method' page for 'Additional pages importer.'
* Added: New inner page 'Look Book' page for 'Additional pages importer.'
* Added: New inner page 'Modern Process' page for 'Additional pages importer.'
* Added: New inner page 'Parallax Presentation' page for 'Additional pages importer.'
* Added: New inner page 'Portfolio' page for 'Additional pages importer.'
* Fixed: Header cart variation space issue fix.
* Fixed: 'Infobox' widget design related issues.
* Fixed: Grid List column layout not working on WooCommerce taxonomy pages.
* Fixed: External product click not working.
* Fixed: Wishlist not showing in the sticky footer.
* Fixed: Variation not showing on 'Related Products'.
* Fixed: Ajax add to cart not working properly
* Fixed: Popup not showing after adding to cart.
* Fixed: Page header not showing on the cart page.
* Fixed: Navigation menu widget disappears after search.
* Fixed: Notice related PHP 8.0
* Updated: Minor code/formatting improvements and fixes.

## Version 4.0.0 (March 22, 2021)
* Added: Elementor page builder support.
* Added: 39 Elementor widgets.
* Added: New elementor category 'Main Demo' and home page for 'Additional pages importer.'
* Added: New elementor category 'Honey' and home page for 'Additional pages importer.'
* Added: New elementor category 'Cookware' and home page for 'Additional pages importer.'
* Added: New elementor category 'decor' and home page for 'Additional pages importer.'
* Added: New elementor category 'surfing' and home page for 'Additional pages importer.'
* Added: New elementor category 'camera' and home page for 'Additional pages importer.'
* Added: New elementor category 'Lighting' and home page for 'Additional pages importer.'
* Added: New elementor category 'Scuba Diving' and home page for 'Additional pages importer.'
* Added: New elementor category 'Toys' and home page for 'Additional pages importer.'
* Added: New elementor category 'Barber Shop' and home page for 'Additional pages importer.'
* Added: New settings in theme options, "Off Canvas sidebar for mobile" in ( CiyaShop Theme Options > WooCommerce > Products Listing ).
* Added: New settings in theme options, "Add Quantity input on cart widget" in ( CiyaShop Theme Options > WooCommerce > Products Listing ).
* Added: New settings in theme options, "AJAX Add to cart" in ( CiyaShop Theme Options > WooCommerce > Products Listing ).
* Added: Footer builder for footer layout.
* Fixed: Errors related to PHP 8.0
* Fixed: Wishlist Not showing in sticky add to cart option.
* Fixed: Pop-up not working for the portfolio.
* Fixed: Hierarchical structure not showing for category drop-down in "Search" of header builder element.
* Fixed: Clear option not working on shop listing page when 'Show variation on shop page' option is enabled.
* Fixed: Topbar Enable/Disable option not working properly.
* Updated: Elementor support for static blocks.
* Updated: Updated language files.
* Updated: 'Add to cart' button will not disappear after the product is added to the cart on the shop listing page.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.10.1 (March 12, 2021)
* Fixed: Off-canvas sidebar not working on category pages.
* Fixed: Price design issue on the single product page when "WooCommerce Currency Switcher" plugin active.
* Fixed: Mega Menu broken text during the hover on the element.
* Fixed: Console errors on product single page.
* Fixed: Active filter not showing when filter area disabled on shop page.
* Added: New setting in theme options ( "Breadcrumb Position" ) for the single product page.
* Updated: Bundled plugins updated to the latest version.

## Version 3.10.0 (March 10, 2021)
* Fixed: Broken structure for "Best Selling Products" shortcode.
* Fixed: Broken structure on shop page when Widget area used as a filter.
* Fixed: Shortcodes not working for product custom tabs editor.
* Fixed: Compare not working for sticky add to cart.
* Fixed: Custom sidebar saving issue after deleting the older sidebars.
* Fixed: select2 dropdown not working properly.
* Fixed: 'Shop Category Icon Carousel' On Loading Height Issue.
* Fixed: Reviews Broken structure on Compare Popup.
* Fixed: Vertical swiping not working on product single page for product thumbnail slider.
* Fixed: Console errors in the admin area.
* Fixed: Product category carousel gets removed on product category archive page.
* Added: New settings in theme options, "Categories Listing Style" and "Background Opacity Color" for category carousal on shop page.
* Added: New setting in theme options ( "Products per page variations" ) for shop page.
* Added: New setting in theme options ( "Product Filter With" ) to enable ajax based filter on the shop page.
* Updated: Removed the product thumbnails slider if the product doesn't have more than one image and update the numbers of images per view.
* Updated: Change the thumbnail image size ( 'woocommerce_thumbnail' ) for the Product thumbnail on a single product page.
* Updated: Add zoom feature in single product page for product image.
* Updated: Quick View structure & design improvements and fixes.
* Updated: Updated language files.
* Updated: 'Shop Category Icon Carousel' All 3 Style Design improvements.
* Updated: Minor code/formatting improvements and fixes.
* Updated: Breadcrumbs Design Update for Product Page.
* Updated: Reviews Tab Design Update for a single product page.
* Updated: Cart and Checkout Page Minor Design improvements and fixes.
* Updated: Bundled plugins updated to the latest version.

## Version 3.9.1.1 (Feb 10, 2021)
* Fixed: Compare element icon options not working for header builder.
* Fixed: Rating does not align properly on compare popup.
* Updated: Remove Compare button from quick view.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.9.1 (Feb 09, 2021)
* Fixed: Wishlist icon not showing in some product hover styles when using the 'YITH WooCommerce Compare' plugin.
* Fixed: Stock label translation issue for product on compare popup.
* Fixed: Product attributes not showing in compare popup.
* Fixed: Multiple loaders on wishlist icon when adding product to wishlist.
* Fixed: Product attribute name not translating in compare popup.
* Fixed: Wrong product showing in wishlist and compare after switching the language when using 'WPML' plugin.
* Updated: Updated language files.

## Version 3.9.0 (Feb 08, 2021)
* Added: Add the string in the WPML file related to the Compare.
* Added: Theme option related to Compare feature in ( CiyaShop Theme Options > WooCommerce > Compare ).
* Fixed: Wishlist not working properly in multisite when the user is not logged in.
* Updated: Make compare product list sortable.
* Updated: Removed the 'YITH WooCommerce Compare' plugin dependencies for the Product Compare feature.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.8.1 (Jan 19, 2021)
* Fixed: 'Header above content' theme option not working.
* Fixed: Wishlist not working correctly for multisite.
* Fixed: design issue on Wishlist Page.

## Version 3.8.0 (Jan 18, 2021)
* Fixed: Nano scroll issue in header cart and 'Product Categories' widget for RTL view.
* Fixed: Thumbnail slider issue in product detail page during page load.
* Fixed: CSS Conflict with 'WOOCS - WooCommerce Currency Switcher' plugin.
* Added: Theme option related to Wishlist feature in ( CiyaShop Theme Options > WooCommerce > Wishlist ).
* Added: Add the string in the WPML file related to the wishlist.
* Updated: Removed the 'YITH WooCommerce Wishlist' plugin dependencies for the wishlist feature.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.7.1 (Dec 21, 2020)
* Fixed: WooCommerce pages assigning issue after demo import.
* Fixed: Theme option's fields css issue in admin are with New Version of the WordPress.
* Fixed: Shortcode converting into the text blocks when editing with the front end editor using the WP Bakery.
* Fixed: HTML tags not saving for 'custom tab' editor while editing the product.
* Fixed: Issue while using the 'Contact Form 7' plugin when using it on WooCommerce pages.
* Fixed: Shop Listing Column RTL Issue Fix.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.7.0 (Dec 03, 2020)
* Fixed: Add option to disable the hover effect for a mobile device, which will disable the double click issue for mobile.
* Updated: Removed the 'Advance Custom Field Pro' plugin dependencies for custom fields. Users can use the theme without using the ACF Plugin.
* Updated: Removed the 'Massive Addons for WPBakery Page Builder' plugin dependencies.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.6.9.1 (Nov 17, 2020)
* Updated: Bundled plugins updated to the latest version.

## Version 3.6.9 (Nov 17, 2020)
* Fixed: Fixed swatch selection issue on shop and product page.
* Fixed: Fixed header cart RTL formatting.

## Version 3.6.8 (Oct 26, 2020)
* Updated: Bundled plugins updated to the latest version.
* Updated: Optimize CSS files.

## Version 3.6.7 (Oct 19, 2020)
* Added: New category Honey.
* Added: New category Ice Cream.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.6.6 (Oct 14, 2020)
* Added: New category Water Shop.
* Added: New category Tools.
* Added: New category Cookware.
* Added: New category Car Parts.
* Fixed: Product Showcase Design issue.
* Fixed: Custom CSS priority issues.
* Fixed: Product infinite scroll issues.
* Fixed: Added fix for session issue in Admin Panel > Tools > Site Health.
* Fixed: Social login not working properly.
* Updated: Implemented new method for Instagram, getting images with Instagram API.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.6.5 (Aug 31, 2020)
* Added: New category Decor.
* Added: New category Yoga Shop.
* Added: New category Vape Shop.
* Added New theme option to enable/disable social login.
* Fixed: Custom add to cart not redirect to cart page when the setting is enabled.
* Fixed: The first icon is not working in icon picker in shortcodes.
* Fixed: Counter shortcode turns in text block shortcode in front editor.
* Updated: WooCommerce templates with the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.

## Version 3.6.4 (Aug 15, 2020)
* Added: New category Beer Shop.
* Added: New category Beard Oil.
* Added: New category Boots Fashion.
* Added: New category Bowhunting.
* Added: New category Camera.
* Added: New category Comic Book Store.
* Added: New category Headphones.
* Added: New category Medicart.
* Added: New category Military.
* Added: New category Surfing.
* Added: Add support for WordPress 5.5
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.6.3 (Aug 01, 2020)
* Fixed: Shop page sidebar display issue on mobile.
* Fixed: CiyaStudio issue fixes.
* Fixed: Shop Filter Design Issue Fixes.
* Fixed: Broken theme options field for the latest version of the Redux framework plugin.
* Fixed: Theme options are not working with the latest version of the Redux framework plugin.
* Updated: introduce new filter for product listing shortcode.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.6.2.1 (July 16, 2020)
* Updated: Improvements in coding standards.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.6.2 (July 10, 2020)
* Fixed: One-page navigation not working for mobile menu.
* Updated: Improvements in coding standards.
* Updated: PHPCS issues, wrong escaping, and bugs related to spacing and code formatting.
* Updated: WooCommerce templates with the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Move the widget to the core plugin.

## Version 3.6.1 (June 22, 2020)
* Added: New category Beer Shop.
* Added: New category Drone.
* Added: New category Lighting.
* Added: New category Olive Oil.
* Added: New category Scuba Diving.

## Version 3.6.0 (June 10, 2020)
* Added: New category Stationery.
* Added: New category Tea Store.
* Added: New category Ceramica.
* Added: New category Marijuana.
* Fixed: wishlist text issues resolve.
* Fixed: Remove the Drop-down if filter empty on the shop page.
* Fixed: 'Thumbnail Position' theme option not working properly for the product.
* Updated: Updated language file.
* Updated: Bundled plugins updated to the latest version.

## Version 3.5.4 (May 05, 2020)
* Fixed: Breadcrum issues resolves
* Updated: Mailchimp messages
* Updated: Updated language file.
* Updated: Bundled plugins updated to the latest version.

## Version 3.5.3 (April 15, 2020)
* Added: Add support for WordPress 5.4
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Improvements in coding standards.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.5.2 (March 16, 2020)
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Improvements in coding standards.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.5.1 (February 14, 2020)
* Added: New shortcode, widget and theme options for Instagram images.
* Added: Implemented new method for Instagram, getting images with Instagram API.
* Added: Yoast Seo Breadcrumb compatibility.
* Added: New custom CSS theme options for different views, e.g., mobile, tablet.
* Fixed: Fixed flag issue in Topbar Language element.
* Fixed: HTML 5 video not working for the blog.
* Updated: Improvements in coding standards.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.5.0 (January 09, 2020)
* Added: New smart product view feature in the single product page.
* Added: Smart Image View shortcode.
* Fixed: Static strings in the JS file and added translations.
* Fixed: Added missing WPBakery custom and shortcode's CSS on the 404 page.
* Fixed: Icon and design update.
* Fixed: Lazy load issue in the front editor.
* Fixed: Hotspot pointer hide issue during the update of the shortcode.
* Fixed: Flat Icon css issue for social icons shortcode.
* Fixed: Kitebox image and content not showing when reaching out to the max number of the item.
* Updated: PHPCS issues, wrong escaping, and bugs related to spacing and code formatting.
* Updated: FontAwesome updated to 5.12.0
* Updated: Improvements in coding standards.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.9 (December 12, 2019)
* Fixed: CiyaShop Studio Image issue.
* Fixed: Compatibility with the new version of the YITH Wishlist plugin.
* Fixed: Wishlist count issue.
* Updated: Wishlist Page New Version Design Update.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.8 (November 25, 2019)
* Fixed: Fixed issue with Quick View.
* Fixed: Minor fix related to datepicker in Banner shortcode not working on WPBAkery Frontend Editor.
* Fixed: Fixed the header builder issue in WordPress 5.3
* Updated: Change the rules for the cookie law info.
* Updated: Update the WooCommerce template with the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.7 (October 11, 2019)
* Fixed: Placeholder image issue.
* Fixed: Shop page banner image issue.
* Fixed: Invalid notice in Theme Setup Wizard when all plugins are activated.
* Fixed: Shop page category carousel issue when the shop page set as the home page.
* Fixed: Fix for search category dropdown.
* Fixed: Product Hover style "info bottom" design issue fix.
* Updated: FAQs Responsive design update.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.6.1 (August 19, 2019)
* Fixed: 'Wp bakery' deprecated function issue.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.6 (August 14, 2019)
* Fixed: Product hover effect issues in mobile.
* Fixed: Empty Cart Design Issue Fix.
* Fixed: Product gallery issues.
* Fixed: WPML quick view and quick add to cart issues resolve.
* Updated: New layouts added to the Ciyashop Studio.
* Updated: WooCommerce templates with the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.5.1 (July 27, 2019)
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.5 (July 26, 2019)
* Added: New "ciyashop_social_share_profiles" filter hook to add custom social sharing service.
* Fixed: Fixed WooCommerce product placeholder image URL issue.
* Fixed: Logo center mega menu issue fix.
* Fixed: Footer Bottom design issue fix.
* Fixed: Category order in search form category dropdown.
* Fixed: Issue with a product where variation images are not displaying/switching in product gallery.
* Fixed: Translation issue in shop filter product attributes.
* Fixed: Issue with Sticky Footer Cart when hiding Price and Cart Features is enabled.
* Fixed: Page header settings not working on the Blog page.
* Fixed: Reconstructed Bestseller Products Widget.
* Fixed: Issue with "Enable Swatch" field in attributes.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.4.1 (July 22, 2019)
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.4 (June 26, 2019)
* Added: Added support to display primary category in products, set with Yoast SEO "Make Primary" setting.
* Added: Added two new filters 'ciyashop_auto_complete_search_args' and 'ciyashop_auto_complete_search_data' to filter autocomplete search arguments and result.
* Fixed: Fixed "Uncategorized" category display issue in search category dropdown.
* Fixed: Fixed string translation.
* Fixed: Fixed variation dropdown formatting in responsive view on product detail page.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language file.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.3 (May 28, 2019)
* Fixed: Wishlist not working for the premium version of "YITH WooCommerce Wishlist" plugin.
* Fixed: Change the deprecated functions.
* Fixed: Loading issue in the back end ( reduce the load time and the unwanted slow queries ).
* Fixed: Loading issue when there are more than 20k products.
* Fixed: Infobox shortcode link issue.
* Fixed: RTL menu responsive dropdown issue fix.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.2 (May 07, 2019)
* Added: New category Toolkito.
* Added: New category Organic Store.
* Added: New category Nails.
* Added: "Social Login" support for the theme.
* Added: Add support for the individual banner on Product tag and categories archive page.
* Fixed: Sticky header jumping issue for header builder. Make a sticky header smoother.
* Fixed: Search element structure different in "Heade Builder" and default header for responsive view.
* Fixed: "Product Showcase" shortcode sale product issue.
* Fixed: Product duplicate issue for "Product Deals" shortcode.
* Fixed: Header builder "Text Block" element issue during the saving the data.
* Fixed: Design Issue with product hover style "Hover Summary."
* Fixed: mac safari sticky Header not working.
* Fixed: The issue regarding the WooCommerce Product Category shortcode in WpBakery Page Builder.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.1 (April 23, 2019)
* Updated: WooCommerce templates with the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.4.0 (April 13, 2019)
* Added: Included WPML Config file.
* Added: Added missing development version of FontIconPicker CSS file.
* Fixed: Color customizer issue between header builder and predefine headers.
* Fixed: Fixed issue where product link was not working on product title.
* Fixed: Breadcrumb WooCommerce product category link issue.
* Fixed: Product listing gird issue fix in mac safari.
* Fixed: Issue fixed with a sticky gallery on the single product page.
* Fixed: Fixed string translation.
* Fixed: Singular and Plural translation issue.
* Updated: Updated language files.
* Updated: "Header Builder" design reconstructed with brand new UI.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.3.1 (February 26, 2019)
* Fixed: Quick view cart not working for a standard quick shop.
* Fixed: Nano scroll issue for the mini cart in the header when product added to cart from compare popup.
* Fixed: Search popup design issue fixes.
* Fixed: WP Bakery "Design Options" not working for the latest version of the "WP Bakery Page Builder".
* Fixed: Cart data update issue for the variable product in header builder.
* Fixed: "Hide Price for Guest User" option not working properly.
* Fixed: scroll after add to cart not working for header builder.
* Fixed: Woo cart count translation.
* Updated: update the WooCommrece template to the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.3.0 (February 18, 2019)
* Added: New feature "Mega Menu" ( Appearance -> Menus -> CS Mega Menu ).
* Added: New shortcode "Menu List" for mega menu ( Pages -> Backend Editor -> Add element -> Menu List ).
* Fixed: Icon loader issue.
* Fixed: Quick view variation align issue fix.
* Fixed: HTML block VC inline CSS not working.
* Updated: Search form improvements.
	- Fixed product category search.
	- Fixed category dropdown hierarchical issue.
	- Added new filter to override search dropdown arguments.
* Updated: Fixed icon issue and added new icon in VC icons shortcode.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.2.0 (January 26, 2019)
* Added: New category Garden.
* Added: New category Game.
* Added: New category Cigar.
* Added: New category Wine.
* Added: New category Digital.
* Added: New category home pages in additional page ( CiyaShop -> Theme Options -> Sample Data -> Additional pages importer ).
* Added: The dark theme layout setting "Dark Theme Version" in theme options ( CiyaShop -> Theme Options -> Layout Settings -> Dark Theme Version ).
* Added: New shortcode "Search" ( Pages -> Backend Editor -> Add element -> Search ).
* Added: Shop page filters reset feature.
* Added: New custom post type "Size Guide".
* Added: New table structure for product size guide.
* Added: The clone header layout feature for header builder.
* Fixed: Header configuration setting radio image issue for header builder.
* Fixed: Fixed "unexpected end of file" error for header builder.
* Fixed: Show categories are not working for header builder in "search" element.
* Updated: Add functionality for change the image and price for the variable product in quick view.
* Updated: "Header builder" element design update.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.1.0 (January 09, 2019)
* Added: Add Header builder to create the custom headers( CiyaShop -> Header Builder).
* Added: Sample header layouts for header builder.
* Added: New theme option "Select Custom Header" for header builder ( CiyaShop -> Theme Options -> Header -> Site Header -> Select Custom Header ).
* Fixed: "Multi Tab Product Listing" shortcode grid and slider border issue fix.
* Fixed: Product border hover style issue fix.
* Fixed: Solve YITH compare remove product issue.
* Fixed: Fix issue with default selected attribute in swatches.
* Updated: Updated language files.
* Updated: Update the select2 js to new version.
* Updated: Bundled plugins updated to the latest version.

## Version 3.0.4 (December 24, 2018)
* Fixed: "Video" shortcode CSS display issue fix.
* Fixed: "Infobox 2" Image Radius Issue fix.
* Fixed: Blog Height Issue Fix for Carousel.
* Fixed: "Banner" shortcode responsive background image issue fix.
* Fixed: Theme options are not working correctly when WPML active.
* Fixed: "Just catalog" mode note working properly.
* Fixed: Variation product ajax add to cart issue for new hover styles.
* Fixed: WooCommerce "Products" shortcode responsive issue fix.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.0.3 (December 08, 2018)
* Updated: Bundled plugins updated to the latest version.

## Version 3.0.2 (December 06, 2018)
* Added: Themify Icons added for shortcodes.
* Added: New shortcode HTML Block added.
* Fixed: Shop "list view" designing issue fix.
* Fixed: Testimonials shortcode style 5 responsive design issue fix.
* Fixed: "Header Above content" header style issue fixed for WooCommerce pages.
* Fixed: Toggle list icon issue for list view on the shop page.
* Fixed: Cart tooltip issue for compare popup.
* Fixed: "Product hover style" design issue fixes.
* Fixed: Shop filters widgets "nanoscroll" issue during the shop filters off.
* Fixed: Sticky header cart issue for nanoscroll.
* Fixed: "Product Actions" not showing for WooCommerce sale product shortcode( ex. Compare, Wishlist, Cart ).
* Fixed: Hotspot design issue fix in responsive view.
* Fixed: Add to cart not working in quick view popup for a single product.
* Fixed: Fixed custom header settings on the Blog page.
* Updated: Bundled plugins updated to the latest version.
* Updated: Price Slider design update.
* Updated: WooCommerce Off Canvas shop sidebar close on click on the side view.
* Updated: Price Slider design update.
* Updated: List icon design changes.
* Updated: Video popup RTL design update.
* Updated: Info box and Info box 2 shortcode design changes.
* Updated: Wishlist page responsive issue fix.
* Updated: Button and Counter shortcode design update.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.0.1 (November 26, 2018)
* Added: "Image Bottom" old hover style add.
* Added: "Image Left" Old hover style add.
* Added: Nano scroll for shop filters attributes, Off-canvas sidebar, and cart widget.
* Added: Text alignment option in "Visual Composer" column settings
* Fixed: Menu header above content issue for wishlist page.
* Fixed: Price Slider Design Update.
* Fixed: Hide price and cart when redux is not active
* Fixed: Cart shows two times on header during scroll effect for "After add to cart" action.
* Fixed: Loader not showing during add to cart for dark "Button Style".
* Fixed: "Progress bar" shortcode - issue for the last element.
* Fixed: Sidebar Design issue fix on Shop Pages.
* Fixed: Icons hover styles color customize issues.
* Updated: Bundled plugins updated to the latest version.
* Updated: "Section Title" shortcode design.
* Updated: Change tooltip position for product actions.
* Updated: Minor code/formatting improvements and fixes.

## Version 3.0.0 (November 19, 2018)
* Added: New Theme options for categories listing slider on shop page ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Categories Settings).
* Added: Additional google fonts functionality in theme options ( CiyaShop Theme Options -> Typography > Additional Fonts ).
* Added: Add new social share options for blog and products sharing ( CiyaShop Theme Options -> Social Sharing ).
* Added: New theme option 'Products Columns On Mobile' ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Products Columns On Mobile ).
* Added: New option for product swatch settings ( CiyaShop Theme Options -> WooCommerce -> Swatch Settings ).
* Added: New option for do action after add to cart. ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> After add to cart ).
* Added: New option 'off canvas sidebar' for shop page ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Off Canvas sidebar ).
* Added: New 'Product Shop Filters' sidebar( Appearance -> Widgets -> Product Shop Filters ).
* Added: New 'PGS Filter Products by Attribute' widget( Appearance -> Widgets -> PGS Filter Products by Attribute ).
* Added: Sticky add to cart option for product detail page( Appearance -> Widgets -> Product Shop Filters ).
* Added: Hide cart for guest user not functionality( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Hide Price for Guest User ).
* Added: New option "Scroll After Add To Cart" in theme option ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Scroll After Add To Cart ).
* Added: 'HTML Blocks' functionalitiy( Custom post type ).
* Added: New Shortcodes
	- Progress Bar
	- Info Box 2
	- Section Title
	- Button
	- Product Category Items
	- Image Slider
	- Hotspot
	- Images Gallery
	- Timeline Item
	- Callout
	- Testimonial
	- Price Box
	- Video
	- Counter
* Fixed: Pagination width issue on product listing page, where paginate links are breaking to another row.
* Fixed: Infinite scroll for categories page not working.
* Fixed: Shop page title issue when filter attribute selected.
* Fixed: Default theme logo not display after resetting the theme option.
* Updated: Create custom 'Breadcrumb' without using the plugin.
* Updated: Add new option 'Filter Type' for use 'Product Shop Filters' sidebar as a filter ( CiyaShop Theme Options -> WooCommerce -> Products Filters -> Filter Type ).
* Updated: New option for 'Product Listing Column' on shop page ( 2 Column ) ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Product Listing Column ).
* Updated: New product hover styles ( CiyaShop Theme Options -> WooCommerce -> Product Listing -> Product Hover Style ).
	- Icons Top Right
	- Button Standard
	- Icons Left
	- Icons Rounded
	- Icons Bottom Right
	- Icons Separate
	- Icons Bottom
	- Icons Bottom Bar
	- Hover Summary
	- Minimal Hover Cart
	- Minimal
	- Info Transparent Center
	- Standard Info Transparent
	- Standard Quick Shop
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.5.0 (November 01, 2018)
* Added: New category Mega Store.
* Added: New category Spa.
* Added: New category Book.
* Added: New category Cake.
* Added: Additional home pages for other categories ( CiyaShop Theme Options -> Sample Data -> Additional pages importer )
* Fixed: Mobile sticky issue fix.
* Updated: Improve the pgs-core plugin.
* Updated: WooCommerce template to the latest version.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.4.3 (October 25, 2018)
* Updated: Bundled plugins updated to the latest version.

## Version 2.4.2 (October 24, 2018)
* Fixed: Reduce google font requests.
* Fixed: Typography font issue fixed.
* Fixed: Product category design issue for "list" and "grid" view fix.
* Fixed: Double cart issue for the sticky header.
* Updated: WooCommerce template to the latest version.
* Updated: Sticky title issue on product single page.
* Updated: WooCommerce new version update design.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.4.1 (October 16, 2018)
* Fixed: Sample data issues fix.
* Fixed: lazy load issues fix.
* Fixed: Multi-tab, cart page, Sidebar Padding Designing issues fixes.
* Fixed: Wishlist Count Color Issue Fix on Custom Header Color Setting.
* Fixed: Blog style "Masonry" issue fix.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.4.0 (October 12, 2018)
* Added: Import additional page functionality ( CiyaShop Theme Options -> Sample Data -> Additional pages importer )
* Added: Portfolio sample data.
* Added: New 'Countdown' shortcode added ( Pages -> Backend Editor -> Add element -> Countdown )
* Added: New styles for 'Recent Post' shortcode ( Pages -> Backend Editor -> Add element -> Recent Posts )
* Added: New footer column layout options in theme options ( CiyaShop Theme Options -> Footer -> Footer Column Layout)
* Added: Woo tools wishlist count in header.
* Added: Portfolio custom post type.
* Added: Portfolio shortcode ( Pages -> Backend Editor -> Add element -> Portfolio )
* Added: Portfolio theme options ( CiyaShop Theme Options -> Portfolio )
* Added: Custom sidebar create option ( Appearance -> Widgets -> Custom Sidebar Widget )
* Added: Page sidebar select option for individual pages ( Pages -> Custome Sidebar )
* Added: Page sidebar position select option for individual pages ( Pages -> Page Sidebar )
* Added: Search options functionality in theme options.
* Added: New options for pagination ( Load more, Infinite scroll ) in product listing page ( CiyaShop Theme Options -> WooCommerce -> Products Listing -> Product Pagination )
* Added: WP Bakery Inner row, Column, Inner column add responsive margin, padding and border option in backend.
* Added: Implement Lazy load ( Beta ) for images ( Performance -> Enable Lazyload )
* Added: Theme options for product filters style on shop page ( CiyaShop Theme Options -> WooCommerce -> Product Filters )
* Added: Widget options for product filters widgets ( Appearance -> Widgets -> PGS Shop Filters )
* Fixed: Infobox design issue
* Fixed: Product Categories Meta text Color issue
* Fixed: Product Filter Widget Checkbox Design issue
* Fixed: Flaticon issues in shortcodes.
* Fixed: Newsletter shortcode style saving issue.
* Fixed: String translations.
* Fixed: Horizontal scroll bar issue
* Updated: Optimize and update all categories sample data.
* Updated: Autocomplete search dropdown hide when clicked outside of search element.
* Updated: Setup wizard design update.
* Updated: Remove extra image sizes.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.
* Updated: Back to top design update.

## Version 2.3.2 (September 21, 2018)
* Added: New theme options for checkout page layouts ( CiyaShop Theme Options -> WooCommerce -> Checkout)
* Added: Different layouts for checkout page.
* Fixed: Cart page responsive design issue fix.
* Fixed: My account responsive page design issue fix.
* Fixed: RTL issues fix for WooCommerce pages.
* Updated: "My account" dashboard page design update.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.3.1 (September 17, 2018)
* Added: New category Chocolate.
* Fixed: One-page menu issue when the menu is null.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.3.0 (September 07, 2018)
* Added: New demo home page 7
* Added: New category Halloween
* Added: New category lingerie
* Added: New Feature "Sticky Footer" add ( CiyaShop Theme Options -> Footer -> Sticky Footer)
* Added: Newsletter shortcode Hover Effect
* Fixed: Menu Issue Fix in responsive view
* Fixed: Testimonial Light and Dark CSS issue
* Fixed: "Newsletter" shortcode, Button Spacing issue
* Fixed: Breadcrumbs icon issue
* Fixed: Promo popup issue in mobile devices.
* Fixed: WooCommerce product import issue
* Updated: Bundled plugins updated to the latest version.

## Version 2.2.0 (August 30, 2018)
* Added: New demo home page 6.
* Added: New category Music Store.
* Added: New category Fishing.
* Added: New category Ceramic.
* Added: New Product Hover Style "Icon Top Left" add ( CiyaShop Theme Options -> WooCommerce -> Product Listing ).
* Added: Search Box Background "Transparent" Style add ( CiyaShop Theme Options -> Header -> Search ).
* Fixed: "Product List View" design update and Design issue Fix.
* Fixed: Fixed lazy loading issue in Visual Composer templates popup( Pages -> Backend Editor -> Templates ).
* Fixed: Button style issue for the new hover style.
* Fixed: Sticky Header visibility issue in mobile devices.
* Updated: Bundled plugins updated to the latest version.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.1.0 (August 28, 2018)
* Added: New category Ayurveda.
* Added: New category Denim.
* Added: 50 new Section add in CiyaShop Studio ( Pages -> Backend Editor -> Templates ).
* Added: Search Box Background styles added ( CiyaShop Theme Options -> Header -> Search ).
* Fixed: Issue resolved with match height javascript in the setup wizard.
* Updated: Minor code/formatting improvements and fixes.

## Version 2.0.0 (August 24, 2018)
* Added: New category Fashion Vintage.
* Added: New category Sports.
* Added: "Add to Cart" on quick view with Ajax.
* Added: Anchor tag on the product title in product listing shortcodes.
* Added: New product hover style in product listing page.
* Added: New setting in theme options to display secondary thumbnail image while hovering on the product in the product listing.
* Added: New style setting for the social share widget.
* Fixed: Added fix for footer widget alignment when Redux Options are not available.
* Fixed: Countdown design fixed on the product listing.
* Fixed: Fixed WooCommerce active check.
* Fixed: Fixed string translations and text-domain.
* Fixed: Header logo's line height issue resolved.
* Fixed: Menu header above content issue fix.
* Fixed: Newsletter design issue fixed.
* Fixed: Newsletter formatting issue in Promo Popup.
* Fixed: Newsletter responsive issue resolved
* Fixed: RTL issue resolved in thumbnail slider.
* Fixed: Resolved Sale label issue.
* Fixed: String escaping fixed.
* Fixed: Topbar Border color issue fixed.
* Updated: Code refactored for new activation process and setup wizard.
* Updated: Updated bundled plugins and sample data installation process to load from the server.
* Updated: Added new filter to change the title of categories menu.
* Updated: Changed Recent Post shortcode image and placeholder image size.
* Updated: Product page design update.
* Updated: Bundled plugins updated to the latest version.
* Updated: Updated language files.
* Updated: Minor code/formatting improvements and fixes.

## Version 1.1.1 (August 21, 2018)
* Added: New category Handmade.
* Added: New category Leather.
* Updated: Bundled plugins updated to the latest version.
* Updated: Grouped product design update
* Updated: Minor code/formatting improvements and fixes.

## Version 1.1.0 (August 16, 2018)
* Added: New home pages for the default category.
* Added: 26 new Section add in CiyaShop Studio ( Pages -> Backend Editor -> Tamplates ).
* Added: New filter to exclude attributes from Shop Filters on WooCommerce product listing page.
* Added: 6 New designs options for style 1 in Newsletter shortcode( Pages -> Backend Editor -> Add element -> Neswletter ).
* Added: New WooCommerce tools(Icons) show hide option for the sticky header( CiyaShop Theme Options -> Sticky Header ).
* Added: New option for anchor tag on Banner shortcode ( Pages -> Backend Editor -> Add element > Banner -> General -> Banner Link ).
* Added: The option for product title length in theme options ( CiyaShop Theme Options -> WooCommerce -> Product Title Length ).
* Added: New option for default menu fonts in header settings ( CiyaShop Theme Options -> Header -> Site Header -> Menu Fonts ).
* Added: New theme options for footer widget individual columns alignment ( CiyaShop Theme Options -> Footer ).
* Added: New title field in the Product Showcase shortcode ( Pages -> Backend Editor -> Add element -> Product Showcase ).
* Added: Deal 1 countdown, 10 new option in the Banner shortcode ( Pages -> Backend Editor -> Add element -> Banner(Deal 1) -> Deal Details ).
* Added: Responsive options for padding in the Banner shortcode ( Pages -> Backend Editor -> Add element -> General -> Banner Padding Responsive).
* Updated: Default category pages update.
	- About US page.
	- About Us 2 page.
	- Contact Us page.
	- Contact Us 2 page.
	- Information page.
	- Terms & Conditions page.
	- Privacy Policy page.
	- Payment Method page.
	- Shipping Method page.
	- Warranty and Services page.
* Updated: Newsletter shortcode, all style shortcode and design update.
* Updated: Bundled plugins updated to the latest version.
* Updated: Theme setup wizard enhancement - setup wizard flow change and improvement.
* Updated: Minor code/formatting improvements and fixes.
* Updated: Banner deal 1 shortcode and design update.
* Fixed: Variable product issue.
* Fixed: Issue regarding Yoast SEO.
* Fixed: Infobox icon design issue fix.
* Fixed: Breadcrumbs design issue fix.
* Fixed: Fixed MailChimp Newsletter signup issue.
* Fixed: RTL - Header Design Issue Fix in Mobile View.

## Version 1.0.3 (August 9, 2018)
* Added: New category weapon.
* Added: New category gift.
* Fixed: Newsletter design issue fix.

## Version 1.0.2 (August 3, 2018)
* Added: New category spice store.
* Added: New category kitchen.
* Updated: Blog style 1 design update.
* Updated: Testimonial style 3 design update.
* Updated: Theme setup wizard enhancement - setup wizard flow change.
* Updated: Bundled plugins updated to the latest version.
* Fixed: Newsletter all 3 style design issue fix.
* Fixed: Sample data fixes.

## Version 1.0.1 (July 27, 2018)
* Added: New category Fashion Classis and Cleaning.
* Updated: Minor code/formatting improvements and fixes.

## Version 1.0.0 (July 26, 2018)
* Initial Release
