<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Sticky Footer Cart file.
 *
 * @package CiyaShop
 */

if ( ! class_exists( 'WooCommerce' ) ) {
	return;
}

if ( isset( $ciyashop_options['hide_price_for_guest_user'] ) && $ciyashop_options['hide_price_for_guest_user'] && ! is_user_logged_in() ) {
	return;
}

$element         = $args['element'];
$element_data    = $args['element_data'];
$element_classes = $element_data['element_classes'];

if ( is_cart() ) {
	$element_classes[] = 'sticky-footer-active';
}

$element_classes = implode( ' ', array_filter( array_unique( $element_classes ) ) );
$cart_count       = ( WC()->cart ) ? WC()->cart->get_cart_contents_count() : 0;
?>
<div class="<?php echo esc_attr( $element_classes ); ?>">
	<?php /* translators: %s: string */ ?>
	<a class="cart-link" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php echo esc_attr( sprintf( esc_attr__( 'View Cart (%s)', 'ciyashop' ), esc_html( $cart_count ) ) ); ?>">
		<?php echo wp_kses( $element_data['icon'], ciyashop_allowed_html( array( 'img', 'i' ) ) ); ?>
		<?php ciyashop_header_cart_count(); ?>
	</a>
</div>
