<?php
/**
 * liem functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package liem
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

define( 'CHECKOUTPAGE_ID', '8' );

global $country_array;
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function liem_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on liem, use a find and replace
		* to change 'liem' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'liem', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'liem' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'liem_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'liem_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function liem_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'liem_content_width', 640 );
}
add_action( 'after_setup_theme', 'liem_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function liem_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'liem' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'liem' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'liem_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function liem_scripts() {
	wp_enqueue_style( 'bootstrap-style', 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css', array(), _S_VERSION );
	wp_enqueue_style( 'liem-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'liem-style', 'rtl', 'replace' );

     wp_enqueue_script( 'jquery' );
	wp_enqueue_script( 'bootstrap-script', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'liem-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'liem_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

$country_array = array(
     "AF" => "Afghanistan",
     "AL" => "Albania",
     "DZ" => "Algeria",
     "AS" => "American Samoa",
     "AD" => "Andorra",
     "AO" => "Angola",
     "AI" => "Anguilla",
     "AQ" => "Antarctica",
     "AG" => "Antigua and Barbuda",
     "AR" => "Argentina",
     "AM" => "Armenia",
     "AW" => "Aruba",
     "AU" => "Australia",
     "AT" => "Austria",
     "AZ" => "Azerbaijan",
     "BS" => "Bahamas",
     "BH" => "Bahrain",
     "BD" => "Bangladesh",
     "BB" => "Barbados",
     "BY" => "Belarus",
     "BE" => "Belgium",
     "BZ" => "Belize",
     "BJ" => "Benin",
     "BM" => "Bermuda",
     "BT" => "Bhutan",
     "BO" => "Bolivia",
     "BA" => "Bosnia and Herzegovina",
     "BW" => "Botswana",
     "BV" => "Bouvet Island",
     "BR" => "Brazil",
     "BQ" => "British Antarctic Territory",
     "IO" => "British Indian Ocean Territory",
     "VG" => "British Virgin Islands",
     "BN" => "Brunei",
     "BG" => "Bulgaria",
     "BF" => "Burkina Faso",
     "BI" => "Burundi",
     "KH" => "Cambodia",
     "CM" => "Cameroon",
     "CA" => "Canada",
     "CT" => "Canton and Enderbury Islands",
     "CV" => "Cape Verde",
     "KY" => "Cayman Islands",
     "CF" => "Central African Republic",
     "TD" => "Chad",
     "CL" => "Chile",
     "CN" => "China",
     "CX" => "Christmas Island",
     "CC" => "Cocos [Keeling] Islands",
     "CO" => "Colombia",
     "KM" => "Comoros",
     "CG" => "Congo - Brazzaville",
     "CD" => "Congo - Kinshasa",
     "CK" => "Cook Islands",
     "CR" => "Costa Rica",
     "HR" => "Croatia",
     "CU" => "Cuba",
     "CY" => "Cyprus",
     "CZ" => "Czech Republic",
     "CI" => "Côte d’Ivoire",
     "DK" => "Denmark",
     "DJ" => "Djibouti",
     "DM" => "Dominica",
     "DO" => "Dominican Republic",
     "NQ" => "Dronning Maud Land",
     "DD" => "East Germany",
     "EC" => "Ecuador",
     "EG" => "Egypt",
     "SV" => "El Salvador",
     "GQ" => "Equatorial Guinea",
     "ER" => "Eritrea",
     "EE" => "Estonia",
     "ET" => "Ethiopia",
     "FK" => "Falkland Islands",
     "FO" => "Faroe Islands",
     "FJ" => "Fiji",
     "FI" => "Finland",
     "FR" => "France",
     "GF" => "French Guiana",
     "PF" => "French Polynesia",
     "TF" => "French Southern Territories",
     "FQ" => "French Southern and Antarctic Territories",
     "GA" => "Gabon",
     "GM" => "Gambia",
     "GE" => "Georgia",
     "DE" => "Germany",
     "GH" => "Ghana",
     "GI" => "Gibraltar",
     "GR" => "Greece",
     "GL" => "Greenland",
     "GD" => "Grenada",
     "GP" => "Guadeloupe",
     "GU" => "Guam",
     "GT" => "Guatemala",
     "GG" => "Guernsey",
     "GN" => "Guinea",
     "GW" => "Guinea-Bissau",
     "GY" => "Guyana",
     "HT" => "Haiti",
     "HM" => "Heard Island and McDonald Islands",
     "HN" => "Honduras",
     "HK" => "Hong Kong SAR China",
     "HU" => "Hungary",
     "IS" => "Iceland",
     "IN" => "India",
     "ID" => "Indonesia",
     "IR" => "Iran",
     "IQ" => "Iraq",
     "IE" => "Ireland",
     "IM" => "Isle of Man",
     "IL" => "Israel",
     "IT" => "Italy",
     "JM" => "Jamaica",
     "JP" => "Japan",
     "JE" => "Jersey",
     "JT" => "Johnston Island",
     "JO" => "Jordan",
     "KZ" => "Kazakhstan",
     "KE" => "Kenya",
     "KI" => "Kiribati",
     "KW" => "Kuwait",
     "KG" => "Kyrgyzstan",
     "LA" => "Laos",
     "LV" => "Latvia",
     "LB" => "Lebanon",
     "LS" => "Lesotho",
     "LR" => "Liberia",
     "LY" => "Libya",
     "LI" => "Liechtenstein",
     "LT" => "Lithuania",
     "LU" => "Luxembourg",
     "MO" => "Macau SAR China",
     "MK" => "Macedonia",
     "MG" => "Madagascar",
     "MW" => "Malawi",
     "MY" => "Malaysia",
     "MV" => "Maldives",
     "ML" => "Mali",
     "MT" => "Malta",
     "MH" => "Marshall Islands",
     "MQ" => "Martinique",
     "MR" => "Mauritania",
     "MU" => "Mauritius",
     "YT" => "Mayotte",
     "FX" => "Metropolitan France",
     "MX" => "Mexico",
     "FM" => "Micronesia",
     "MI" => "Midway Islands",
     "MD" => "Moldova",
     "MC" => "Monaco",
     "MN" => "Mongolia",
     "ME" => "Montenegro",
     "MS" => "Montserrat",
     "MA" => "Morocco",
     "MZ" => "Mozambique",
     "MM" => "Myanmar [Burma]",
     "NA" => "Namibia",
     "NR" => "Nauru",
     "NP" => "Nepal",
     "NL" => "Netherlands",
     "AN" => "Netherlands Antilles",
     "NT" => "Neutral Zone",
     "NC" => "New Caledonia",
     "NZ" => "New Zealand",
     "NI" => "Nicaragua",
     "NE" => "Niger",
     "NG" => "Nigeria",
     "NU" => "Niue",
     "NF" => "Norfolk Island",
     "KP" => "North Korea",
     "VD" => "North Vietnam",
     "MP" => "Northern Mariana Islands",
     "NO" => "Norway",
     "OM" => "Oman",
     "PC" => "Pacific Islands Trust Territory",
     "PK" => "Pakistan",
     "PW" => "Palau",
     "PS" => "Palestinian Territories",
     "PA" => "Panama",
     "PZ" => "Panama Canal Zone",
     "PG" => "Papua New Guinea",
     "PY" => "Paraguay",
     "YD" => "People's Democratic Republic of Yemen",
     "PE" => "Peru",
     "PH" => "Philippines",
     "PN" => "Pitcairn Islands",
     "PL" => "Poland",
     "PT" => "Portugal",
     "PR" => "Puerto Rico",
     "QA" => "Qatar",
     "RO" => "Romania",
     "RU" => "Russia",
     "RW" => "Rwanda",
     "RE" => "Réunion",
     "BL" => "Saint Barthélemy",
     "SH" => "Saint Helena",
     "KN" => "Saint Kitts and Nevis",
     "LC" => "Saint Lucia",
     "MF" => "Saint Martin",
     "PM" => "Saint Pierre and Miquelon",
     "VC" => "Saint Vincent and the Grenadines",
     "WS" => "Samoa",
     "SM" => "San Marino",
     "SA" => "Saudi Arabia",
     "SN" => "Senegal",
     "RS" => "Serbia",
     "CS" => "Serbia and Montenegro",
     "SC" => "Seychelles",
     "SL" => "Sierra Leone",
     "SG" => "Singapore",
     "SK" => "Slovakia",
     "SI" => "Slovenia",
     "SB" => "Solomon Islands",
     "SO" => "Somalia",
     "ZA" => "South Africa",
     "GS" => "South Georgia and the South Sandwich Islands",
     "KR" => "South Korea",
     "ES" => "Spain",
     "LK" => "Sri Lanka",
     "SD" => "Sudan",
     "SR" => "Suriname",
     "SJ" => "Svalbard and Jan Mayen",
     "SZ" => "Swaziland",
     "SE" => "Sweden",
     "CH" => "Switzerland",
     "SY" => "Syria",
     "ST" => "São Tomé and Príncipe",
     "TW" => "Taiwan",
     "TJ" => "Tajikistan",
     "TZ" => "Tanzania",
     "TH" => "Thailand",
     "TL" => "Timor-Leste",
     "TG" => "Togo",
     "TK" => "Tokelau",
     "TO" => "Tonga",
     "TT" => "Trinidad and Tobago",
     "TN" => "Tunisia",
     "TR" => "Turkey",
     "TM" => "Turkmenistan",
     "TC" => "Turks and Caicos Islands",
     "TV" => "Tuvalu",
     "UM" => "U.S. Minor Outlying Islands",
     "PU" => "U.S. Miscellaneous Pacific Islands",
     "VI" => "U.S. Virgin Islands",
     "UG" => "Uganda",
     "UA" => "Ukraine",
     "SU" => "Union of Soviet Socialist Republics",
     "AE" => "United Arab Emirates",
     "GB" => "United Kingdom",
     "US" => "United States",
     "ZZ" => "Unknown or Invalid Region",
     "UY" => "Uruguay",
     "UZ" => "Uzbekistan",
     "VU" => "Vanuatu",
     "VA" => "Vatican City",
     "VE" => "Venezuela",
     "VN" => "Vietnam",
     "WK" => "Wake Island",
     "WF" => "Wallis and Futuna",
     "EH" => "Western Sahara",
     "YE" => "Yemen",
     "ZM" => "Zambia",
     "ZW" => "Zimbabwe",
     "AX" => "Åland Islands",
 );