<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package liem
 */

get_header();
?>
		<?php
		while ( have_posts() ) :
			the_post();
			$url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()), 'full' ); 
		?>
		<section class="py-5">
			<div class="container px-4 px-lg-5 my-5">
		        <div class="row gx-4 gx-lg-5 align-items-center mb-5">
		            <div class="col-md-6"><img class="card-img-top mb-5 mb-md-0" src="<?php echo $url; ?>" alt="<?php echo get_the_title(); ?>" /></div>
		            <div class="col-md-6">
		                <div class="small mb-1">SKU: BST-498</div>
		                <h1 class="display-5 fw-bolder"><?php echo get_the_title(); ?></h1>
		                <div class="fs-5 mb-5">
		                    <span class="text-decoration-line-through">$45.00</span>
		                    <span>$40.00</span>
		                </div>
		                <p class="lead"><?php echo get_the_excerpt(); ?></p>
		                <div class="d-flex">
		                    <input class="form-control text-center me-3" id="inputQuantity" type="num" value="1" style="max-width: 3rem" />
		                    <a 
		                    	class="btn btn-outline-dark flex-shrink-0" 
		                    	href="<?php echo get_the_permalink( CHECKOUTPAGE_ID )."?add_to_cart=".get_the_id(); ?>">
		                        <i class="bi-cart-fill me-1"></i>
		                        Buy Now
		                    </a>
		                </div>
		            </div>
		        </div>

		        <div class="row gx-4 gx-lg-5 align-items-center">
		            <div class="col-md-12 lead"><?php echo get_the_content(); ?></div>
		        </div>
		    </div>
		</section>    
		<?php	
		endwhile; // End of the loop.
		wp_reset_postdata();
		?>

	<section class="py-5 bg-light">
		<div class="container px-4 px-lg-5 mt-5">
		    <div class="row gx-4 gx-lg-5 row-cols-2 row-cols-md-3 row-cols-xl-4 justify-content-center">
			<?php
			$args = array(
							'post_type' => 'post',
							'posts_per_page' => 4,
							'post__not_in' => array(get_the_ID()),
						);
			$the_query = new WP_Query( $args );

			if ( $the_query->have_posts() ) :
				while ( $the_query->have_posts() ) : $the_query->the_post();
					
					/*
					 * Include the Post-Type-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_type() );

				endwhile;

			endif;
			// Reset Post Data
			wp_reset_postdata();
			?>
	    	</div>
		</div>	
	</section>	
<?php
get_footer();
